#!/usr/bin/python
import random

pages = [("You tense as you slip into the central bridge; your arrival [italic type]can't[roman type] have gone unnoticed, and this would make a perfect ambush point.\n\nHowever, there isn't anyone here except Dr. Sinister himself, flipping through paperwork behind a mahogany desk.", [("'Your fiendish scheme ends here!'", 1), ("'Your sinister plan is foiled!'", 2), ("[bracket]Punch him.[close bracket]", 3)]), # 0
         ("'Your fiendish scheme ends here, Doctor!'\n\nDr. Sinister looks up, supremely unimpressed. 'Is that really the best you can do?'\n\n'Er...'\n\n'Do you even know what my fiendish scheme [italic type]is[roman type]?'",  [("'Of course!'", 15), ("'I don't need to.'", 16), ("[bracket]Punch him.[close bracket]", 6)]), # 1
         ("'Your sinister plan is foiled, Doctor!'\n\nDr. Sinister raises an eyebrow. 'Is that an insect I hear buzzing?'", [("'Insect?'", 4), ("'You're awfully calm.'", 5), ("[bracket]Punch him.[close bracket]", 6)]), # 2
         ("You advance on the doctor, winding up. He puts his paper down and makes some futile warding gestures. 'Whoa whoa whoa whoa whoa, Hummingbird. What did I ever do to you?'", [("'Super-sharks.'", 7), ("'Orbital Doom Cannons.'", 8)]), # 3
         ("'The Hummingbird is no insect! And now...'\n\n'[bold type]SILENCE![roman type]' Dr. Sinister's fist comes hammering down on his mahogany desk. 'Since when does CPR send an also-ran like you against a threat of my awesome caliber?'", [("'I beat you handily.'", 18), ("'You're still only human.'", 17), ("[bracket]Punch him.[close bracket]", 6)]), # 4
         ("'You're awfully blas[unicode 233] for someone whose master plan is falling apart around his ears.'\n\n'Is it, though?'", [("'Your plan is hopeless.'", 17), ("'I've beaten you.'", 18), ("[bracket]Punch him.[close bracket]", 6)]), # 5
         ("'Enough. This ends now.' You advance on the doctor, winding up. He begins shrinking back in his chair and makes some futile warding gestures. 'Whoa whoa whoa whoa whoa, Hummingbird. What did I ever do to you?'", [("'Super-sharks.'", 7), ("'Orbital Doom Cannons.'", 8)]), # 6
         ("'Well, there was your army of genetically-modified sharks.'\n\nSinister blanches. 'You were able to defeat them? They should have been more than a match for the likes of you.'\n\nYou think back. 'Actually, now that you mention it, no; I just flew out of their reach.'\n\n'You can fly. Doesn't count.'", [("'Trap doors.'", 9), ("'Orbital Doom Cannons.'", 8)]), # 7
         ("'There's this [italic type]entire station[roman type], which you've built around a huge doomcannon.'\n\n'That never threatened [italic type]you[roman type]. It would have been able to hold the world hostage in a few more hours, but...'\n\n'I've wasted far too much time with this as it is. Enough.' You wind up again, but Dr. Sinister again waves you off.\n\n'No, really, that won't be necessary. I'll come quietly. I know when I'm beaten.'", []), # 8
         ("'There's the deadfall in your office.'\n\n'You can fly. doesn't count.'\n\n'But...'\n\n'And you shouldn't have been rummaging through my stuff.'", [("'The laser grid.'", 10), ("'Orbital Doom Cannons.'", 8)]), # 9
         ("'What about those lasers blocking your hangar?'\n\n'What about them?'\n\n'It vaporized [a grid victim] pretty good.'\n\n'And?'", [("'It's not like you.'", 11), ("'It's dangerous.'", 12)]), # 10
         ("'And it was right out in the open! Everything else I'd seen about you shows great concern with a safe working environment. What if one of your henchmen tripped?'\n\nDr. Sinister looks somewhat taken aback by this. 'The grid was usually off except in dire circumstances. I would never...'\n\n'Don't give me that. The switch was on when I found it, and at the time you left you thought you held all the cards.'\n\nHe actually looks kind of crestfallen.", [("'Are you OK?'", 13), ("'We've wasted enough time.'", 14)]), # 11
         ("'And, well, that's a threat.'\n\n'It's a security grid! It's no more a threat than the locks on my doors. If you're going to claim I'm some big villain, you'll have to show better than that.'", [("'Well, there's your orbital doom cannon...'", 8)]),
         ("You tilt your head quizzically. 'You know, CPR doesn't generally send me after the worst of the worst, but even so that kind of concern for your minions is rare.'\n\n'[if the number of depressurized access corridors is zero]Loyalty is easily lost. Why borrow trouble?'[otherwise]More than you showed!' Dr. Sinister's voice quivers with rage. 'If you're anything to go by, it's totally fine for a hero to risk killing dozens of people just because they're in the way and have the wrong boss! I ought to...' He lunges over the table at you, swinging wildly.\n\nEvil science clearly hasn't given him time to study hand-to-hand combat; you easily block his attack and maneuver him into a grip where he is harmless.[end if]", [("'We're running out of time.'", 14), ("'Are you sure you're on the right side?'", 19)]),
         ("You harden your expression. 'We don't have time for this. You have [italic type]no idea[roman type] how precarious your situation your situation is right now.'\n\n'Oh?'\n\n'CPR knows exactly where you are and is completely ready to blow all of us out of space before you get anywhere near the West Coast. You've been doomed basically since you took off in the first place.'\n\nDr. Sinister narrows his eyes. 'Why send you, then?'", [("'To save you guys.'", 20), ("'To make them unnecesary.'", 21)]),
         ("'I know enough. There's a cylindrical core running through the center of the station, and a beam charge countdown was visible on the status screen on the way here. You've got some kind of orbital superweapon, and it'll be ready to fire about the time your orbit takes you over North America.'\n\nDr. Sinister smiles, and not in a friendly way, either. 'And how do you propose to stop it? My systems are automated.'", [("'I don't have to.'", 14), ("[bracket]Punch him.[close bracket]", 6)]),
         ("'I'm here at the Coalition's behest. The exact details of your sinister plan are really kind of beside the point.'\n\nDr. Sinister raises an eyebrow. 'You're admitting that outright? What makes you any different from my own minions?'", [("'I [italic type]prevent[roman type] my bosses from pulling out the big guns.'", 14), ("'My bosses are vastly more powerful.'", 17), ("[bracket]Punch him.[close bracket]", 6)]),
         ("You shake your head. 'For all you've managed to do, Doc, you and your organization are still only a Class IV entity[if Finding Counters has ended]. You prepared to fight Class II and Class I enemies, but e[otherwise]. E[end if]ven a Class III like me could and did smash through your defenses. And I'm the weakest class CPR will field. If you get their [italic type]full[roman type] attention, they will crush you like a [italic type]bug[roman type].'\n\n'Empty boasts don't impress me.'\n\n'You got their full attention as soon as you launched from your island base. The only reason a multinational military strike hasn't [italic type]already[roman type] turned this whole station into a meteor shower over the Pacific is because I convinced them to let me try to resolve this less explosively.'\n\nDr. Sinister steeples his fingers. 'And why would you have done that?'", [("'To save lives.'", 20), ("'That kind of force isn't necessary here.'", 21)]),
         ("'Why the sneering? Belittling me only diminishes yourself. I crushed all the threats you threw at me.'\n\n'Oh? Like what? I prepared for the likes of Star R Star, not insects like you.'", [("'Super-sharks.'", 7), ("'Orbital Doom Cannons.'", 8)]),
         ("[if the number of depressurized access corridors is zero]You meet his gaze evenly. 'Well, it's time for you to repay that loyalty.  We've probably only got a few minutes left before CPR decides I failed and the Air Forces respond with massive retaliation. We're getting out of here. It'll be easier on all of us if you go quietly.'\n\n'No need to to push harder. I know when I'm beaten.'[otherwise]Dr. Sinister struggles in your grip.\n\n'That rage?' you ask him. 'That's [italic type]hatred of injustice[roman type], Doctor. I have no idea why you bothered with this whole plan, Doctor, but once you're brought to justice...'\n\n'Yes?'\n\n'I'll be testifying for both sides. For the prosecution as to what's happened, and as a character witness for the defense.' The Doctor is speechless. 'Now let's get out of here - there are so many better things you could be doing, and by God we're going to find out what they are if it kills you.'[end if]", []),
         ("'You might have missed this, but I'm one of the good guys[if the number of depressurized access corridors is not zero].'\n\n'It's easy to miss when you're committing acts of sabotage that threaten the entire station.'\n\n'Your henchmen are more than skilled enough to handle minor damage like that[end if]. I'm not a fan of pointlessly wasting lives. That includes yours and your men's.'\n\nYou gesture at the door. 'It's over. Save who you can, and just come quietly.'\n\nDr. Sinister considers you, and nods slowly. 'If what you say is true, it sounds like I may owe you my thanks.' Just then the screens on his desk glow red. He looks at it briefly. 'Yes. Thank you. Let's go.'", []),
         ("'Because, all told, I'd just as soon it not come to that.' Out of the corner of your eye, you see his desk screens blinking alerts. 'It looks like they've decided I failed. Care to prove them wrong?'\n\nDr. Sinister hesitates, but the look on his face betrays him, and you know that...", []),
]

def permute (l):
    result = []
    while len (l) > 0:
        i = random.randint(0, len(l) - 1)
        result.append(l[i])
        l = l[:i] + l[i+1:]
    return result

def cyoa():
    indices = [1] + permute(range(2, len(pages)+1))
    revmap = {}
    for (i, r) in zip(indices, range(len(pages))):
        revmap[i] = r

    for i in range(1, len(pages)+1):
        (t, o) = pages[revmap[i]]
        print "%d\n%s\n%s" % (i, "-" * len(str(i)), t)
        print
        if o == []:
            print "  *** You have won ***"            
        for (k, v) in o:
            print "  - %s - go to %d" % (k, indices[v])
        print

def i7code():
    print "[The code in this section is autogenerated by confront.py. Don't edit it directly; instead, edit the .py file.]"
    print
    print "Table of Quip Texts (continued)"
    print "quip\tquiptext"
    for i in range(len(pages)):
        print "q_endgame_%02d\t\"%s\"" % (i, pages[i][0])
    print
    print "Table of Quip Followups (continued)"
    print "quip\toption\tresult"
    for i in range(len(pages)):
        for (k, v) in pages[i][1]:
            print "q_endgame_%02d\t\"%s\"\tq_endgame_%02d" % (i, k, v)
    print
    for i in range(len(pages)):
        if pages[i][1] == []:
            print "After quipping when the current quip is q_endgame_%02d, end the game in victory." % i

i7code()
